local a = 0

function dump(o)
   if type(o) == 'table' then
      local s = '{ '
      for k,v in pairs(o) do
         if type(k) ~= 'number' then k = '"'..k..'"' end
         s = s .. k .. ' = ' .. dump(v) .. ','
      end
      return s .. '} '
   else
      return tostring(o)
   end
 end

 function magnitude(v)
    return math.sqrt(v.x * v.x + v.y * v.y)
 end

 function subtract(first, second)
   return {x = first.x - second.x, y = first.y - second.y}
 end

 function dot(first, second)
   return first.x * second.x + first.y * second.y
 end

 function angle(dir)
   return math.atan2(dir.y, dir.x)
 end

 function direction_from_angle(angle)
   return {x = math.cos(angle), y = math.sin(angle)}
 end


 function divide(first, second)
   return {x = first.x / second, y = first.y / second}
 end

local targets = {}

function player_by_handle(others, handle)
   for _, player in ipairs(others) do
      if player.handle == handle then
         return player
      end
   end
   return nil
end

function update_player(idx, me, others)

   if #others == 0 then
      print("no targets")
      return
   end

   if targets[idx] == nil then
      targets[idx] = others[ math.random( #others ) ].handle
      print(string.format("ai %i picked player %i", idx, targets[idx]))
   end
   target_player = player_by_handle(others, targets[idx])

   if target_player == nil then
      print(string.format("ai %i has no target", idx))
      targets[idx] = nil
      return
   end

   -- print(string.format("ai %i targeting player %i", idx, target_player.handle))


   direction = subtract(target_player.position, me.position)

   -- rotate towards the player
   angle_to_player = angle(direction)
   diff = me.angle - angle_to_player
   if diff < 0 then
      diff = diff + math.pi * 2.0
   end

   if math.abs(diff) > 0.02 then
      if diff > math.pi then
         me.move(ROTATE_LEFT)
      else
         me.move(ROTATE_RIGHT)
      end
   end

   -- determine if accelerating is beneficial to get closer to player
   speed_towards = dot(direction, me.velocity) / magnitude(direction)
   distance = magnitude(direction)
   accelerate_would_fly_towards = dot(direction, direction_from_angle(me.angle)) > 0.0

   did_accelerate = false
   if accelerate_would_fly_towards then
      -- if we're far away and not already going too fast towards, accelerate towards the player
      if speed_towards < 100.0 and distance > 250.0 then
          me.move(ACCELERATE)
          did_accelerate = true
      end

      -- if we're moving away, always accelerate towards the player
      if speed_towards < 0.0 then
         me.move(ACCELERATE)
         did_accelerate = true
      end
   end

   -- if a % 10 == 0 then
   --    print(string.format("speed towards player: %f, distance: %f", speed_towards, distance))
   --    print(string.format("angle to player: %f", angle_to_player))
   -- end

   -- default to using the laser
   weapon_type = LASER

   -- if we're outside laser range, use the cannon
   if distance > LASER_RANGE then
      weapon_type = CANNON
   end

   if me.weapon ~= weapon_type then
      me.cycle_weapon()
   else
      -- fire only if we're roughly facing towards
      if accelerate_would_fly_towards then
         if weapon_type == CANNON and did_accelerate == false then
            -- don't fire the cannon if we're still accelerating
            me.fire()
         else
            -- if we're using the laser, we must be close enough; always fire if we're roughly facing the right way
            me.fire()
         end
      end
   end

   a = a + 1
end
